 ; Ŀ
 ;   N: entity data extractor.                                             
 ;   Copyright 1995, 1998, 2002 - 2008 by Rocket Software Ltd.             
 ;   For those with a pathological fear of the F1 key ... oops - F2.       
 ; 
 (DEFUN C:N (/ *error* pa esav entt zed snapp boxes aa ll grpstr pdat grdat
               atts segpts num seglen len ten ons len name just elv twist vta
                                                                          zxp)
 ; Ŀ
 ;   Angora - see if angles in a list increment in multiples of pi/2.      
 ;   Arguments: Alist, a list: ((length angle bulge) ...)                  
 ;   Returns t or nil.                                                     
 ; 
 (DEFUN ANGORA (alist / stilok num sub panga pbnga remora)
  (setq stilok t)
  (setq num 0)
  (while (setq sub (nth num alist))
         (setq num (1+ num))
         (setq panga (cadr sub))
 ; Ŀ
 ;   Rounding errors complicate this.                                      
 ;   Line 1: if the absolute value of the difference between the angles    
 ;   is very small (but not always 0) then the angles are at 90 degrees.   
 ;   Line 2: (rem 6 3) = 0, and (rem 6 2.999) is close to zero, but        
 ;   (rem 6 3.0001) = 2.9999, so must check again for a remainder which    
 ;   is very close to the divisor.                                         
 ;   Note that we are checking for close, not less than, hence the abs.    
 ;   Really need a rem function with a fuzz factor.  Or a rem=0 function.  
 ; 
         (if (not (or (null pbnga)
                      (> 0.000001 (setq remora (rem (abs (- panga pbnga))
                                                    (/ pi 2))))
                      (> 0.000001 (abs (- remora (/ pi 2))))))
             (setq stilok ()))
         (setq pbnga panga))
 stilok)
 ; Ŀ
 ;   Angora end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Cartlg: returns the length of an arc.                      
 ; 
 (DEFUN CARTLG (arcent / cent stangl endang radd incang incdeg arclen)
 ; Ŀ
 ;   Get various entity data.                                              
 ; 
  (setq cent (cdr (assoc 10 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
  (setq radd (cdr (assoc 40 arcent)))
  (if (> stangl endang)
      (setq incang (- (* 2 pi) (- stangl endang)))
      (setq incang (abs (- stangl endang))))
 ; Ŀ
 ;   Now calculate the length: pi*radius*included_angle/180.               
 ; 
  (setq incdeg (* 180 (/ incang pi)))
  (setq arclen (/ (* pi radd incdeg) 180))
 arclen)
 ; Ŀ
 ;   Cartlg end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Colf - find the colour of an entity.                       
 ; 
 (DEFUN COLF (enam / tt zz ss num entt)
  (setq entt (entget enam))
  (setq zcol (cdr (assoc 62 entt)))
  (cond ((null zcol) "Bylayer")
        ((= zcol 0)  "Byblock")
        ((= zcol 1)  "Red")
        ((= zcol 2)  "Yellow")
        ((= zcol 3)  "Green")
        ((= zcol 4)  "Cyan")
        ((= zcol 5)  "Blue")
        ((= zcol 6)  "Magenta")
        ((= zcol 7)  "White")
        (T (itoa zcol))))
 ; Ŀ
 ;   Colf end.                                                             
 ; 

 ; Ŀ
 ;   Couat - count the attributes in a block insertion (not definition.)   
 ;   Argument: Enam, the insertion ename.                                  
 ;   Calls nothing.                                                        
 ;   Returns a number, possibly zero.                                      
 ; 
 (DEFUN COUAT (enam / num)
  (setq num 0)
  (if (assoc 66 (entget enam))
      (while (/= "SEQEND" (cdr (assoc 0 (entget (setq enam (entnext enam))))))
             (setq num (1+ num))))
 num)
 ; Ŀ
 ;   Couat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Glept: Get the details of an LwPolyline.                   
 ;   Takes one argument, the ename.                                        
 ; 
 (DEFUN GLEPT (enam / entt close eleva num sub tenlst end1 end2)
  (setq entt (entget enam))
  (if (= 1 (logand 1 (cdr (assoc 70 entt))))
      (setq close t))
  (if (and (setq eleva (cdr (assoc 38 entt))) (/= eleva 0))
      (setq eleva (strcat ", Elev: " (rtos eleva 2 1)))
      (setq eleva ""))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (= (car sub) 10)
             (setq tenlst (cons sub tenlst)))
         (setq num (1+ num)))
  (if close
      (setq segs (strcat ", Segs: " (itoa (length tenlst))))
      (setq segs (strcat ", Segs: " (itoa (1- (length tenlst))))))
 (list close eleva segs))
 ; Ŀ
 ;   Glept end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Grot - find the rotation of an entity.                     
 ; 
 (DEFUN GROT (enam / entt rota)
  (setq entt (entget enam))
  (if (setq rota (cdr (assoc 50 entt)))
      (strcat ", R: " (rtos (* 180 (/ rota pi)) 2 1))))
 ; Ŀ
 ;   Grot end.                                                             
 ; 

 ; Ŀ
 ;   Grrr - get group data for an entity.                                  
 ;   Argument: Enam - the entity name.                                     
 ;   Returns a list of lists: ((group_name member_ename ...) ...)          
 ;   or nil if the entity wasn't a member of any groups.                   
 ;                                                                         
 ;   Note that a group can't contain other groups as such - including one  
 ;   group in another adds its members.                                    
 ; 
 (DEFUN GRRR (enam / entt grlist master mast2)
  (setq entt (entget enam))
 ; Ŀ
 ;   There will be one 330 group in the entity data for each group to      
 ;   which the object belongs.  Note that an entity can belong to          
 ;   multiple groups.  So get a list of their enames.                      
 ;   Also: check to see if this really is a group and not some other type  
 ;   of reactor.  (The 0 group in the entity data for the 330 group in     
 ;   the original entity is (0 . "GROUP"))                                 
 ; 
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (and (= (car sub) 330)
                  (= (cdr (assoc 0 (entget (cdr sub)))) "GROUP"))
             (setq grlist (cons (cdr sub) grlist)))
         (setq num (1+ num)))
 ; Ŀ
 ;   If any of the 330 enames were Groups, add the enames of the entities  
 ;   contained in each group to the appropriate sublist.                   
 ; 
  (if grlist
      (progn
           (setq num 0)
           (while (setq grenam (nth num grlist))
                  (setq subent (entget grenam))
                  (setq newlst (list grenam))
                  (setq subnum 0)
                  (while (setq sub (nth subnum subent))
                         (if (= (car sub) 340)
                             (setq newlst (append newlst (list (cdr sub)))))
                         (setq subnum (1+ subnum)))
                  (setq master (cons newlst master))
                  (setq num (1+ num)))
 ; Ŀ
 ;   Add the group name of each group to the start of its sublist.         
 ;   First get a copy of the master group list.                            
 ; 
           (setq grdict (dictsearch (namedobjdict) "acad_group"))
           (setq grnams (reverse grdict))
 ; Ŀ
 ;   Get the name for each group from the list.                            
 ; 
           (setq num 0)
           (while (setq sub (nth num master))
                  (setq grenam (car sub))
                  (setq grpnam (cadr (member (cons 350 grenam) grnams)))
                  (setq sub (cons (cdr grpnam) sub))
                  (setq mast2 (cons sub mast2))
                  (setq num (1+ num)))))
 mast2)
 ; Ŀ
 ;   Grrr end.                                                             
 ; 

 ; Ŀ
 ;   Icvp: returns a string detailing the attdef settings.                 
 ; 
 (DEFUN ICVP (enam / seven i c v p)
  (setq seven (cdr (assoc 70 (entget enam))))
  (setq i (if (= (logand seven 1) 1) "I" "i"))
  (setq c (if (= (logand seven 2) 2) "C" "c"))
  (setq v (if (= (logand seven 4) 4) "V" "v"))
  (setq p (if (= (logand seven 8) 8) "P" "p"))
 (strcat i c v p))
 ; Ŀ
 ;   Icvp end.                                                             
 ; 

 ; Ŀ
 ;   Isxref: see if a given block is an xref.                              
 ;   Arguments: Blnam, either an entity name or a block name string.       
 ;   Returns T if the block was an xref, else nil.                         
 ; 
 (DEFUN ISXREF (blnam / dat xp isxrf)
  (if (= (type blnam) 'ename)
      (setq blnam (cdr (assoc 2 (entget blnam)))))
  (setq dat (tblsearch "block" blnam))
  (setq xp (cdr (assoc 70 dat)))
  (setq isxrf (logand xp 4))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxref end.                                                           
 ; 

 ; Ŀ
 ;   Justx - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.                    
 ; 
 (DEFUN JUSTX (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "TEXT")
      (setq yjust (cdr (assoc 73 entt)))
      (setq yjust (cdr (assoc 74 entt))))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T"))      ; top
        (T           (setq yjst "")))      ; default
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F"))      ; fit
        (T           (setq xjst "L")))     ; default
  (setq justrg (strcat yjst xjst)))
 ; Ŀ
 ;   Justx end.                                                            
 ; 

 ; Ŀ
 ;   Lemat - see if opposite sides of a rectangle have the same lengths.   
 ;   Arguments: Alist, a list: ((length angle bulge) ...)                  
 ;   Returns a string describing the two dimensions or nil.                
 ; 
 (DEFUN LEMAT (alist / len1 ang1 len2 ang2 len3 ang3 len4 ang4 lens1 lens2)
 ; Ŀ
 ;   Extract the side lengths and angles from the list thereof.            
 ; 
  (setq len1 (caar alist))
  (setq ang1 (cadar alist))
  (setq len2 (caadr alist))
  (setq ang2 (cadadr alist))       ; ((1 2 3) (1 2 3) (1 2 3) (1 2 3))
  (setq len3 (caaddr alist))
  (setq ang3 (cadr (nth 2 alist)))
  (setq len4 (car (nth 3 alist)))
  (setq ang4 (cadr (nth 3 alist)))
 ; Ŀ
 ;   If the first and third sides and the second and fourth are matching   
 ;   lengths, make a string to describe the rectangle.  (Have already      
 ;   checked for four sides and square corners in the main routine.)       
 ;   Also try to assign vertical and horizontal directions.                
 ; 
  (if (and (equal len1 len3 0.0000001)
           (equal len2 len4 0.0000001))
      (progn
 ; Ŀ
 ;   Cond: the first and third sides are horizontal.                       
 ; 
           (cond ((and (memphis ang1 (list 0 pi) 0.001)
                       (equal (abs (- ang1 ang3)) pi 0.001))
                  (setq lens1 (strcat (rtos len1 2 2) "h")))
 ; Ŀ
 ;   Or vertical.                                                          
 ; 
                 ((and (memphis ang1 (list (/ pi 2) (* pi 1.5)) 0.001)
                       (equal (abs (- ang1 ang3)) pi 0.001))
                  (setq lens1 (strcat (rtos len1 2 2) "v")))
 ; Ŀ
 ;   Or some other angle.                                                  
 ; 
                 (t (setq lens1 (rtos len1 2 2))))
 ; Ŀ
 ;   Cond: the second and fourth sides are horizontal.                     
 ; 
           (cond ((and (memphis ang2 (list 0 pi) 0.001)
                       (equal (abs (- ang2 ang4)) pi 0.001))
                  (setq lens2 (strcat (rtos len2 2 2) "h")))
 ; Ŀ
 ;   Or vertical.                                                          
 ; 
                 ((and (memphis ang2 (list (/ pi 2) (* pi 1.5)) 0.001)
                       (equal (abs (- ang2 ang4)) pi 0.001))
                  (setq lens2 (strcat (rtos len2 2 2) "v")))
 ; Ŀ
 ;   Or some other angle.                                                  
 ; 
                 (t (setq lens2 (rtos len2 2 2))))))
 ; Ŀ
 ;   Return a string if both substrings had values, else nil.              
 ; 
 (if (and lens1 lens2)
     (strcat lens2 " x " lens1)
     nil))
 ; Ŀ
 ;   Lemat end.                                                            
 ; 

 ; Ŀ
 ;   Lk - see if the layer on which an entity lies is locked.              
 ;   Takes one argument, the entity ename, returns a string.               
 ; 
 (DEFUN LK (enam / lay sev)
  (setq lay (cdr (assoc 8 (entget enam))))
  (setq sev (cdr (assoc 70 (tblsearch "layer" lay))))
  (if (= 4 (logand sev 4)) "Locked " ""))
 ; Ŀ
 ;   Lk end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Ltypf - returns the linetype of an entity or "" if it is   
 ;   bylayer.                                                              
 ; 
 (DEFUN LTYPF (enam / entt ltyp)
  (setq entt (entget enam))
  (if (setq ltyp (cdr (assoc 6 entt)))
      (strcat ", Lt: " (strcase (substr ltyp 1 1))
                       (strcase (substr ltyp 2) t)) ""))
 ; Ŀ
 ;   Ltypf end.                                                            
 ; 

 ; Ŀ
 ;   Memphis - See if an argument is a member of a list, allows a fuzz     
 ;   factor.                                                               
 ;   Arguments: King, the thing to check for membership.                   
 ;              Prisc, a list.                                             
 ;              Fuzz, a fuzz factor.                                       
 ;   Returns the list starting with the first matching element, or nil.    
 ;   Note that (equal "a" "a" 0.01) is ok - the fuzz factor is ignored.    
 ; 
 (DEFUN MEMPHIS (king prisc fuzz / bubba sub)
  (while (setq sub (car prisc))
         (setq num (1+ num))
         (if (equal king sub fuzz)
             (setq bubba prisc))
         (setq prisc (cdr prisc)))
 bubba)
 ; Ŀ
 ;   Memphis end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine N - show the contents of a block on the screen menu.       
 ;   (Not currently used.)                                                 
 ; 
 (DEFUN N (enam / blip boxes entt tagg taglst len num)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq boxes (getvar "screenboxes"))
  (if (and (setq entt (entget enam))
           (assoc 66 entt))
      (progn
           (setq num 0)
           (while (and (<= num boxes) ; don't wait on huge blocks
                       (setq entt (entget (setq enam (entnext enam))))
                       (/= (cdr (assoc 0 entt)) "SEQEND"))
                  (grtext -2 (itoa (setq num (1+ num))))
                  (setq tagg (cdr (assoc 1 entt)))
                  (if (= tagg "") (setq tagg "..."))
                  (setq taglst (append taglst (list tagg))))
           (setq taglst (reverse taglst))
           (if (and (> boxes 0) (> (setq len (length taglst)) boxes))
               (write-line (strcat "\nNumber of attributes exceeds slots ("
                                    (itoa boxes) ").")))
           (while (and (setq tagg (car taglst))
                       (> boxes 0))
                  (setq taglst (cdr taglst))
                  (setq boxes (1- boxes))
                  (grtext boxes tagg))
           (while (> boxes 1)
                  (setq boxes (1- boxes))
                  (grtext boxes " "))
           (if (= boxes 1)
               (grtext 0 (nopath))))
      (progn
           (grtext)
           (if entt (grtext 25 (cdr (assoc 2 entt))))))
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Subroutine N end.                                                     
 ; 

 ; Ŀ
 ;   Subroutine Nopath - returns the drawing name without the path.        
 ;   Called only by (n), so not currently used.                            
 ; 
 (DEFUN NOPATH ( / tt pos)
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Onsnap - see if a point is on snap.                        
 ; 
 (DEFUN ONSNAP (pa / dimscl ress ons)
  (setq snapunit (getvar "snapunit"))
  (setq pax (car pa))
  (if (zerop (car snapunit))
      (setq ons 0)
      (progn
           (setq ress (/ pax (car snapunit)))
           (if (= ress (fix ress))
               (progn
                    (setq pay (cadr pa))
                    (setq ress (/ pay (cadr snapunit)))
                    (setq ress (* 2 ress))
                    (if (= ress (fix ress))
                        (setq ons T))))))
 (cond ((= ons 0) ", *Snap not set*.")
       (ons "")
       (T ", Not on snap.")))
 ; Ŀ
 ;   Onsnap end.                                                           
 ; 

 ; Ŀ
 ;   Pf: find the lwpline, pline, or line segment a point lies on.         
 ;   Takes two arguments: the point and the pline ename.                   
 ;   Returns a list: the number of vertices and the endpoints of the       
 ;   segment containing the point, or the number of vertices and nil.      
 ;   If the entity is a line then the number of vertices is usually 2,     
 ;   other entity types return nil.                                        
 ;   Caution: doesn't check for closed polylines.                          
 ; 
 (DEFUN PF (pa enam / typ closed entt num entt2 end1 pasav end2 angg pb pint
                                                              entt1 vnum sub)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
 ; Ŀ
 ;   Polyline.                                                             
 ; 
  (cond ((= typ "POLYLINE")
         (setq closed (if (= 1 (logand 1 (cdr (assoc 70 entt)))) t))
         (setq num 0)
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt2
                                       (entget (setq enam (entnext enam)))))))
                (setq num (1+ num))
                (if (and entt1 entt2 (null pint))
                    (progn
                         (setq end1 (cdr (assoc 10 entt1)))
                         (if (null pasav) (setq pasav end1))
                         (setq end2 (cdr (assoc 10 entt2)))
                         (setq angg (angle end1 end2))
                         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
                         (setq pint (inters end1 end2 pa pb))))
                (if (null pint)
                    (setq entt1 entt2)))
 ; Ŀ
 ;   If the point wasn't on a segment and the polyline was closed, try     
 ;   the implicit closed segment.                                          
 ; 
         (if (and (null pint) closed)
             (progn
                  (setq end1 pasav)
                  (setq angg (angle end1 end2))
                  (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
                  (setq pint (inters end1 end2 pa pb))))
         (if pint
            (list num end1 end2)
            (list num ())))
 ; Ŀ
 ;   Lwpolyline.                                                           
 ; 
        ((= typ "LWPOLYLINE")
         (setq closed (if (= 1 (logand 1 (cdr (assoc 70 entt)))) t))
         (setq vnum (setq num 0))
         (while (setq sub (nth num entt))
                (setq num (1+ num))
                (if (= (car sub) 10)
                    (progn
                         (setq vnum (1+ vnum))
                         (setq end2 (cdr sub))
                         (if (null pasav) (setq pasav end2))
                         (if (and end1 end2 (null pint))
                             (progn
                                  (setq angg (angle end1 end2))
                                  (setq pb (polar pa (+ angg (/ pi 2))
                                                                     0.000001))
                                  (if (inters end1 end2 pa pb)
                                      (setq pint (list end1 end2)))))
                         (if (null pint) (setq end1 end2)))))
 ; Ŀ
 ;   If the point wasn't on a segment and the lwpolyline was closed, try   
 ;   the implicit closed segment.                                          
 ; 
         (if (and (null pint) closed)
             (progn
                  (setq end2 pasav)
                  (setq angg (angle end1 end2))
                  (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
                  (if (inters end1 end2 pa pb)
                      (setq pint (list end1 end2)))))
         (if pint
            (cons vnum pint)
            (list vnum ())))
 ; Ŀ
 ;   Line.                                                                 
 ; 
        ((= typ "LINE")
         (setq end1 (cdr (assoc 10 entt)))
         (setq end2 (cdr (assoc 11 entt)))
         (setq angg (angle end1 end2))
         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
         (setq pint (inters end1 end2 pa pb))
         (if pint
            (list 2 end1 end2)
            (list 2 ())))
        (T nil)))
 ; Ŀ
 ;   Pf end.                                                               
 ; 

 ; Ŀ
 ;   Plbx: see if a polyline is a box, if so then measure it.              
 ;   Arguments: Enam, a polyline entity name.                              
 ;   Returns a description string or "" if the polyline wasn't a box.      
 ; 
 (DEFUN PLBX (enam / pllist lenz)
 ; Ŀ
 ;   Get a list of segment data.                                           
 ; 
  (if (= (cdr (assoc 0 (entget enam))) "POLYLINE")
      (setq pllist (pm enam))
      (setq pllist (plm enam)))
 ; Ŀ
 ;   A box has four sides, each angle is 90 degrees (/ pi 2) more or less  
 ;   than the previous one, and sides 1 and 3 and sides 2 and 4 have       
 ;   matching lengths.                                                     
 ; 
  (if (and (= (length pllist) 4)
           (angora pllist)
           (setq lenz (lemat pllist)))
      (strcat ", Box: " lenz)
      ""))
 ; Ŀ
 ;   Plbx end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Plm: Extract data from a lwpolyline.                       
 ;   Arguments: Enam, a polyline ename.                                    
 ;   Returns a list: ((length angle bulge) ...)                            
 ; 
 (DEFUN PLM (enam / closed entt pa pa0 sub plist bulge pb)
  (setq entt (entget enam))
 ; Ŀ
 ;   See if the polyline is closed.                                        
 ; 
  (setq closed (if (= 1 (logand 1 (cdr (assoc 70 entt)))) t))
 ; Ŀ
 ;   Extract various information from the polyline.                        
 ; 
  (setq num 0)
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (= (car sub) 10)
             (progn
                  (setq pa (cdr sub))
                  (if (null pa0) (setq pa0 pa))
                  (if pb
                     (progn
                          (setq sub (list (distance pa pb)
                                          (angle pa pb)
                                           bulge))
                          (setq plist (append plist (list sub)))))))
         (if (= (car sub) 42) (setq bulge (cdr sub)))
         (setq pb pa))
 ; Ŀ
 ;   If the polyline is closed and the final segment has a length, then    
 ;   add it to the list.                                                   
 ; 
  (if (and closed (not (equal pa pa0 0.0000001)))
      (progn
           (setq sub (list (distance pa0 pa)
                           (angle pa0 pa)
                           bulge))
           (setq plist (append plist (list sub)))))
 plist)
 ; Ŀ
 ;   Subroutine Plm end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Pm: Extract data from a polyline.                          
 ;   Arguments: Enam, a polyline ename.                                    
 ;   Returns a list: ((length angle bulge) ...)                            
 ; 
 (DEFUN PM (enam / closed entt pa pa0 sub plist bulge pb)
 ; Ŀ
 ;   See if the polyline is closed.                                        
 ; 
  (setq closed (if (= 1 (logand 1 (cdr (assoc 70 (entget enam))))) t))
 ; Ŀ
 ;   Extract various information from the polyline.                        
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam)))))))
         (setq pa (cdr (assoc 10 entt)))
         (if (null pa0) (setq pa0 pa))
         (if pb
             (progn
                  (setq sub (list (distance pa pb)
                                  (angle pa pb)
                                  bulge))
                  (setq plist (append plist (list sub)))))
         (setq bulge (cdr (assoc 42 entt)))
         (setq pb pa))
 ; Ŀ
 ;   If the polyline is closed and the final segment has a length, then    
 ;   add it to the list.                                                   
 ; 
  (if (and closed (not (equal pa pa0 0.0000001)))
      (progn
           (setq sub (list (distance pa0 pa)
                           (angle pa0 pa)
                           bulge))
           (setq plist (append plist (list sub)))))
 plist)
 ; Ŀ
 ;   Subroutine Pm end.                                                    
 ; 

 ; Ŀ
 ;   Subroutine Pollen - find the length of a polyline or lwpline.         
 ; 
 (DEFUN POLLEN (enam / totlen entt closed next pa pasav pb)
  (setq totlen 0)
 ; Ŀ
 ;   Lwpolyline.                                                           
 ; 
  (cond ((= (cdr (assoc 0 (entget enam))) "LWPOLYLINE")
         (setq entt (entget enam))
         (setq closed (if (= 1 (logand 1 (cdr (assoc 70 entt)))) t))
         (while (setq next (car entt))
                (setq entt (cdr entt))
                (if (= (car next) 10)
                    (progn
                         (setq pa (cdr next))
                         (if (null pasav) (setq pasav pa))
                         (if (and pa pb)
                             (setq totlen (+ totlen (distance pa pb))))
                         (setq pb pa))))
         (if closed (setq totlen (+ totlen (distance pa pasav)))))
 ; Ŀ
 ;   Polyline.                                                             
 ; 
        ((= (cdr (assoc 0 (setq entt (entget enam)))) "POLYLINE")
         (setq closed (if (= 1 (logand 1 (cdr (assoc 70 entt)))) t))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                (setq pa (cdr (assoc 10 entt)))
                (if (null pasav) (setq pasav pa))
                (if (and pa pb)
                    (setq totlen (+ totlen (distance pa pb))))
                (setq pb pa))
         (if closed (setq totlen (+ totlen (distance pa pasav))))))
 totlen)
 ; Ŀ
 ;   Subroutine Pollen end.                                                
 ; 

 ; Ŀ
 ;   Subroutine Tail: find the total length of a polyline.                 
 ; 
 (DEFUN TAIL (enam / entt pa pb dist)
  (setq dist 0)
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                    "SEQEND")
         (if pa (setq pb pa))
         (setq pa (cdr (assoc 10 entt)))
         (if (and pa pb) (setq dist (+ dist (distance pa pb)))))
 dist)
 ; Ŀ
 ;   Tail end.                                                             
 ; 

 ; Ŀ
 ;   N - the nameless interrogator.                                        
 ;   The opening Defun statement has been moved to the beginning so that   
 ;   all subroutines are defined locally and N won't crash when other      
 ;   routines are loaded.                                               )( 
 ; 
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "snapmode" snapp)
  (if typ (prompt typ))
 (princ))
 ; Ŀ
 ;   Turn off snap.                                                        
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Get an entity.                                                        
 ; 
  (setq aa (entsel "Select entity:\n"))
  (if aa
     (progn
 ; Ŀ
 ;   Data common to all entities.                                          
 ; 
          (setq entt (entget (setq enam (car aa)) (list "*")))
          (setq pa (cadr aa))
          (setq typ (cdr (assoc 0 entt)))
 ; Ŀ
 ;   The next four (any which are preceded in the output by an asterisk)   
 ;   are more warnings than data, being settings which aren't commonly     
 ;   or perhaps wisely used.                                               
 ;   See if there is any extended entity data.                             
 ; 
          (setq exdat (if (assoc -3 entt) " *Ex*" ""))
 ; Ŀ
 ;   Elevation.                                                            
 ; 
          (if (and (setq ten (assoc 10 entt))
                   (setq zed (cadddr ten))
                   (/= zed 0))
              (setq exdat (strcat exdat " *Elv*")))
 ; Ŀ
 ;   Entity Ltscale (1 = use global setting.)                              
 ; 
          (if (and (setq ltscl (assoc 48 entt))
                   (setq ltscl (cdr ltscl))
                   (/= ltscl 1))
              (setq exdat (strcat exdat " *Lt:" (rtos ltscl 2 2))))
 ; Ŀ
 ;   Entity Lineweight.                                                    
 ; 
          (if (and (setq lweigt (assoc 370 entt))
                   (setq lweigt (cdr lweigt)))
              (setq exdat (strcat exdat " *Lwt:" (rtos lweigt 2 2))))
 ; Ŀ
 ;   Layer.                                                                
 ; 
          (setq ll (cdr (assoc 8 entt)))
 ; Ŀ
 ;   Get the entity insertion, this is slightly different for a polyline.  
 ; 
          (if (= typ "POLYLINE")
              (setq ten (cdr (assoc 10 (entget (entnext enam)))))
              (if ten (setq ten (cdr ten))))
 ; Ŀ
 ;   See if the ten point is on snap, get layer etc.                       
 ; 
          (if ten
              (setq ons (onsnap ten))
              (setq ons ""))
          (setq zcol (colf enam))
          (if (= zcol "Bylayer")
              (setq zcol "")
              (setq zcol (strcat ", Col: " zcol)))
          (setq ltyp (ltypf enam))
          (if (null (setq rota (grot enam))) (setq rota ""))
          (setq layy (strcat ", " (lk enam) "Layer: " ll))
 ; Ŀ
 ;   If the entity belongs to any groups, get their names.                 
 ; 
          (if (and (assoc 330 entt)
                   (setq grdat (grrr enam)))
              (progn
                   (setq grpstr ", Gr:")
                   (while (setq sub (car grdat))
                          (setq grdat (cdr grdat))
                          (setq grpstr (strcat grpstr " " (car sub) ",")))
                   (setq grpstr (substr grpstr 1 (1- (strlen grpstr)))))
              (setq grpstr ""))
 ; Ŀ
 ;   Entity data depending on the entity type.                             
 ;   Arc.                                                                  
 ; 
          (cond ((= typ "ARC")
                 (setq rad (cdr (assoc 40 entt)))
                 (setq len (cartlg entt))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     ", Radius: " (rtos rad 2 2)
                                     ", Len: " (rtos len 2 2)
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Attdef.                                                               
 ; 
                ((= typ "ATTDEF")
                 (setq hght (rtos (cdr (assoc 40 entt)) 2 1))
                 (setq wid (rtos (cdr (assoc 41 entt)) 2 2))
                 (setq styl (cdr (assoc 7 entt)))
                 (setq font (cdr (assoc 3 (tblsearch "style" styl))))
                 (setq just (justx entt))
                 (write-line (strcat typ " " just
                                     layy
                                     grpstr
                                     ", " styl "/" font
                                     ", Ht: " hght
                                     ", Wd: " wid
                                     rota
                                     " " (icvp enam)
                                     zcol
                                     ons exdat)))
 ; Ŀ
 ;   Block insertion.                                                      
 ; 
                ((= typ "INSERT")
                 (if (> (setq atts (couat enam)) 0)
                     (setq atts (strcat ", Atts: " (itoa atts)))
                     (setq atts ""))
                 (setq aa (cdr (assoc 2 entt))) 
                 (if (/= (substr aa 1 1) "*")
                     (setvar "insname" aa))
                 (setq xscal (cdr (assoc 41 entt)))
                 (if (equal xscal (fix xscal) 0.000001)
                     (setq xscal (itoa (fix xscal)))
                     (setq xscal (rtos xscal 2 1)))
                 (setq yscal (cdr (assoc 42 entt)))
                 (if (= yscal (fix yscal))
                     (setq yscal (itoa (fix yscal)))
                     (setq yscal (rtos yscal 2 1)))
                 (setq zscal (cdr (assoc 43 entt)))
                 (if (= zscal (fix zscal))
                     (setq zscal (itoa (fix zscal)))
                     (setq zscal (rtos zscal 2 1)))
                 (write-line (strcat (if (isxref enam) "Xref" "Block")
                                     ": " aa
                                     layy
                                     grpstr
                                     ", Scale " xscal "/" yscal "/" zscal
                                     atts
                                     rota
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Circle.                                                               
 ; 
                ((= typ "CIRCLE")
                 (setq radd (rtos (cdr (assoc 40 entt)) 2 2))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     ", Radius: " radd
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Dimension.                                                            
 ; 
                ((= typ "DIMENSION")
                 (if (and (setq asoc1 (assoc 1 entt))
                          (/= (cdr asoc1) ""))
                          (setq deftxt ", Not default text")
                          (setq deftxt ", Default text"))
                 (if (setq asoc3 (assoc 3 entt))
                     (setq dimstl (strcat ", Style: " (cdr asoc3)))
                     (setq dimstl ""))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     deftxt
                                     dimstl
                                     zcol
                                     ltyp
                                     ons exdat)))
 
 ; Ŀ
 ;   Hatch.                                                                
 ; 
                ((= typ "HATCH")
                 (if (setq asoc2 (assoc 2 entt))
                     (progn
                          (setq hapat (cdr asoc2))
                          (setq hapat (strcat (strcase (substr hapat 1 1))
                                              (strcase (substr hapat 2) t)))
                          (setq hapat (strcat ", Style: " hapat)))
                     (setq hapat ""))
                 (if (setq asoc41 (assoc 41 entt))
                     (setq hasc (strcat ", Sc: " (rtos (cdr asoc41))))
                     (setq hasc ""))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     hapat
                                     hasc
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Line.                                                                 
 ; 
                ((= typ "LINE")
                 (setq len (distance ten (setq elv (cdr (assoc 11 entt)))))
                 (setq angg (angle ten elv))
                 (setq angg (rtos (* 180 (/ angg pi)) 2 1))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     ", Length: " (rtos len 2 2)
                                     ", Ang: " angg
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Polyline.                                                             
 ; 
                ((= typ "POLYLINE")
                 (setq pboxp (plbx enam))
 ; Ŀ
 ;   Get the length of the picked segment and the overall length.          
 ; 
                 (setq pa (osnap pa "near"))
 ; Ŀ
 ;   Note: if the picked segment has a bulge factor then the point won't   
 ;   be on a line between the two ends, so (cadr segpts) will be nil.      
 ; 
                 (setq segpts (pf pa enam))
                 (setq num (car segpts))     ; number of vertices
                 (if (cadr segpts)
                     (setq seglen (distance (cadr segpts) (caddr segpts))))
                 (setq len (pollen enam))
                 (setq swidth (cdr (assoc 40 entt)))
                 (if (= swidth (fix swidth))
                     (setq swidth (itoa (fix swidth)))
                     (setq swidth (rtos swidth 2 1)))
                 (setq ewidth (cdr (assoc 41 entt)))
                 (if (= ewidth (fix ewidth))
                     (setq ewidth (itoa (fix ewidth)))
                     (setq ewidth (rtos ewidth 2 1)))
                 (if (= 16 (logand 16 (cdr (assoc 70 entt))))
                     (setq mesh " MESH")
                     (setq mesh ""))
                 (if (= 1 (logand 1 (cdr (assoc 70 entt))))
                     (setq cl "/CL")
                     (progn
                          (setq cl "/OP")
                          (setq num (1- num))))
                 (write-line (strcat typ mesh
                                     layy
                                     grpstr
                                     ", Width: " swidth
                                     (if seglen
                                         (strcat ", Len: " (rtos len 2 2)
                                                 ", Seg Len: "
                                                 (rtos seglen 2 2))
                                         ", *Bulges")
                                     ", Segs: " (itoa num) cl
                                     pboxp
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   LwPolyline.                                                           
 ; 
                ((= typ "LWPOLYLINE")
                 (setq pboxp (plbx enam))
 ; Ŀ
 ;   Get the length of the picked segment and the overall length.          
 ; 
                 (setq pa (osnap pa "near"))
                 (setq segpts (pf pa enam))
                 (if (cadr segpts)
                     (setq seglen (distance (cadr segpts) (caddr segpts))))
                 (setq len (pollen enam))
                 (setq pdat (glept enam))
                 (setq elv (nth 1 pdat))
                 (setq segs (nth 2 pdat))
                 (setq swidth (cdr (assoc 40 entt)))
                 (if (= swidth (fix swidth))
                     (setq swidth (itoa (fix swidth)))
                     (setq swidth (rtos swidth 2 1)))
                 (setq ewidth (cdr (assoc 41 entt)))
                 (if (= 1 (logand 1 (cdr (assoc 70 entt))))
                     (setq cl "/CL")
                     (setq cl "/OP"))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     ", Width: " swidth
                                     (if seglen
                                         (strcat ", Len: " (rtos len 2 2)
                                                 ", Seg Len: "
                                                 (rtos seglen 2 2))
                                         ", *Bulges")
                                     segs cl
                                     pboxp
                                     zcol
                                     ltyp
                                     ons exdat
                                     elv)))
 ; Ŀ
 ;   Text.                                                                 
 ; 
                ((= typ "TEXT")
                 (setq hght (rtos (cdr (assoc 40 entt)) 2 1))
                 (setq wid (rtos (cdr (assoc 41 entt)) 2 2))
                 (if (setq styl (cdr (assoc 7 entt)))
                     (progn
                          (setq stldat (tblsearch "style" styl))
                          (setq font (cdr (assoc 3 stldat)))
                          (if (/= "" (setq bigfnt (cdr (assoc 4 stldat))))
                              (setq bigfnt (strcat "/Bf:" bigfnt))))
                     (progn
                          (setq styl "No Style")
                          (setq font "")
                          (setq bigfnt "")))
                 (setq just (justx entt))
                 (write-line (strcat typ " " just
                                     layy
                                     grpstr
                                     ", " styl 
                                     (if (= styl "No Style") "" "/")
                                     font bigfnt
                                     ", Ht: " hght
                                     ", Wd: " wid
                                     rota
                                     zcol
                                     ons exdat)))
 ; Ŀ
 ;   Viewport.                                                             
 ; 
                ((= typ "VIEWPORT")
                 (if (not (equal (setq twist (cdr (assoc 51 entt)))
                                  0 0.000000001))
                     (progn
                          (setq twist (rtos (* (/ 180 pi) twist)))
                          (setq vta (strcat ", Twist: " twist)))
                     (setq vta ""))
                 (setq zxp (strcat ", Scale: 1:"
                                    (rtos (/ (cdr (assoc 45 entt))
                                             (cdr (assoc 41 entt))) 2 3)))
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     vta
                                     zxp
                                     zcol
                                     ltyp
                                     ons exdat)))
 ; Ŀ
 ;   Anything else.                                                        
 ; 
                (T 
                 (write-line (strcat typ
                                     layy
                                     grpstr
                                     ltyp
                                     zcol
                                     ons
                                     exdat)))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
       (write-line "Nothing selected."))
  (setvar "snapmode" snapp)
 (princ))